/* ROBERT CHRISTOPHERSON      415-697-9136                                 */
/* 10-30-91                                                                */
/* Fluke                      upload.c (Sun File name, x = 3 or 4)         */
/* Microsoft C                SUN System                                   */

/* ********************* Program Description ***************************** */
/*                                                                         */
/*  This program waits for commands from the Fluke to load files from the  */
/*  Sun System to the Fluke 9100 Functional Board tester.                  */
/* *********************************************************************** */

/* ********************** REVISIONS   ************************************ */
/* DATE            CHANGE                                                  */
/* -----------  -------------------------------------------------          */
/* 1-22-92      Added '\r' to WriteComString in Sun4_232.c and removed     */
/*              from upload.c (this program).                              */
/*                                                                         */
/* *********************************************************************** */

/* **  DOS & Sun Files  **   */

#include <ctype.h>
#include <string.h>
#include <time.h>
#include <malloc.h>

/* **  Sun Files         ***   */
#include <curses.h>            /* includes <stdio.h>,<termio.h>,<unctrl.h> */
#include <sys/termios.h>
#include <sys/fcntl.h>         /* Bui's include file     */
#include <sys/signal.h>        /* sys/ in Sun system     */

/*#include <stdio.h>       */
/* #include <process.h>    */
/*#include <sys/types.h>   */     /* collides with termios.h */
/* #include <sys/stat.h>   */
/* #include <stdlib.h>     */

/* ************************ Constants ************************************ */
#define FOREVER 1
#define DEBUG 0                         /* enable to display info          */
#define AUTO 1
#define SELECT 2
#define CUR_REV 3
#define SINGLE_FILE 4
#define TEMP2 5
#define COMMAND 3                      /* Received request from Fluke      */
#define DATA_IN 2
#define TIMED_OUT 1
#define NO_DATA 0
#define DIR 0
#define NAME 1
#define INPUT_DIR 2

#define TRUE 1
#define FALSE 0

/* ***************** External Variables  ********************************  */

/* *****************   Function Prototypes ******************************  */

int upload();          /*  */
int upload_file();     /*  */
int upload_all();

/*-------------------------------------------------------------------------*/
/*                     Begin SUBROUTINES                                       */
/*-------------------------------------------------------------------------*/

int upload()
   {   /* **********  Begin Input    ************************************* */
   char input_buf[400];
   char send_string[300];
   char temp_string[300];
   char dir_name[100];
   char file_name[40];

   int temp;
   int command, i;
   command = DIR;

   /* ********  requested Directory name from the Fluke   ************** */
   strcpy(send_string,"DIR");
   /* strcat(send_string,"\r");                     */
   printf("Sending %s\n",send_string);
   if (WriteComString(send_string) == FALSE)
      {
       printf("Error in sending DIR to the Fluke\n");
       return;
      }
   usleep(10);
   /* ********  Receive Directory Name from Fluke     ****************** */
   temp = ReadComPort(input_buf);
   strcpy(dir_name,input_buf);         /* ** Input directory name       */
   printf("DIR response = %s\n",input_buf);
   if (temp == NO_DATA || temp == TIMED_OUT)
      {
       printf("No directory name received - Timed_out or No_data\n");
       strcpy(send_string, "ERROR - Sun did not receive Directory Name.");
       WriteComString(send_string);
       return;
      }
   i = 0;

   /* **********  Requested File Name from the Fluke  ******************* */
   strcpy(send_string, "NAME");
   printf("Sending %s\n",send_string);
   WriteComString(send_string);
   usleep(10);
   /* **********  Receive File Name from the Fluke   ******************** */
   input_buf[1] = '\0';
   temp = ReadComPort(file_name);
   printf("NAME response = %s\n",file_name);
   if (temp == NO_DATA || temp == TIMED_OUT)
      {
      printf("Timed Out/No_Data received for file name\n");
      strcpy(send_string, "ERROR - Sun did not receive File Name.");
      WriteComString(send_string);
      return;
      }

   /* *********  Received File Names OK               ****************** */
   /* *********  Ask Fluke if it is ready to Receive Files   *********** */
   strcpy(send_string, "ACK");
   printf("Sending %s\n",send_string);
   WriteComString(send_string);
   printf("Transferring File: %s/%s\n",dir_name,file_name);

   if ( search(file_name,"*") )              /* load multiple files  */
      upload_all(dir_name);
   else                                          /* load single file     */
      {
      strcat(dir_name,"/");
      strcat(dir_name,file_name);                /* Input File Name  *** */
      temp = upload_file(dir_name);           /*    */
      }             /* ----------  END IF "*"    ----------------------- */


   temp_string[0] = '\f';
   temp_string[1] = '\0';
   WriteComString(temp_string);

   strcpy(temp_string,"HALT");      /* removed '\r'    */
   WriteComString(temp_string);

    ;
   return;
   }

/* **************       END OF UPLOAD ROUTINE    ************************ */

/* *************  Transfer File FROM Sun TO Fluke   ********************* */
int upload_all(dir)

   char *dir;

   {
    char temp_string[200];
    char send_string[200];        /* temporary storage to send to         */
                                  /* WriteComString.                      */
                                  /* (WriteComString ADDS a CR            */

    char list[200];
    char c;
    int count,file_count,i,temp;
    char names[150][180];         /* *** limited to 150 filenames  ****    */
    char input_file[200];
    char input_port[200];
    char temp_file[200];

    FILE *in_file;    /*    */
    FILE *fopen();

    strcpy(list,"ls ");
    strcat(list,dir);
    strcat(list," > temp_file");
    system(list);                  /* save list of files in temporary file */

    /* printf("upload_all() received directory name :\n"); */   /* */
    /*printf("%s\n",dir);                                  */   /* */

    usleep(1000);

    strcpy(temp_string,"./temp_file");        /*  */
    in_file = fopen(temp_string,"r");
    if ( in_file  == NULL )
      {
       printf("could not open file listing (temp_file)\n");
       strcpy(send_string,"ERROR - Could not open the file 'temp_file'");
       WriteComString(send_string);
       return;
       }

    count = 0;
    file_count = 0;
    temp_string[0] = '\0';
    /* printf("file_count before EOF = %d\n",file_count);  */     /* */

    while (c !=EOF)
       {
        c = fgetc(in_file);
        temp_string[count] = c;
        count++;
        /* printf("%c",c);  */    /* */
        if (c == '\n')
           {
            count--;                    /* kill the linefeed character     */
            temp_string[count] = '\0';
            count = 0;
            strcpy(names[file_count],temp_string);
            /*printf("names[%d] = %s\n",file_count,names[file_count]);*//* */
            file_count++;
           }       /* --- END IF c = '\n'    ----------------------------- */

        }      /* ------  END WHILE (c != EOF)   ------------------------- */

    if (file_count < 1)
       {
           printf("No Files in this directory!\n");
           strcpy(send_string,"ERROR - No files in ");
           strcat(send_string,dir);
           WriteComString(send_string);
           return;
        }                    /*  END IF i = 0      ** */

  file_count--;                /*    *** reset to last name saved  ***     */


  printf("Transferring following files:\n");
  for ( i=0; i < file_count+1; i++)
      printf("%s, ",names[i]);
  printf("\n");

  for ( i = 0; i < file_count+1; i++) /* ------ for i < file_count + 1 --- */
   {
    input_port[1] = '\0';
    temp = ReadComPort(input_port); /* receive File Name request from Fluke*/
    printf("SEND response = '%s' for file: %s\n", input_port,names[i]); /* */
    if (temp == NO_DATA || temp == TIMED_OUT)
      {
       printf("Timed Out/No_Data received for file name request file: %s\n",names[i]);
       strcpy(send_string,"ERROR - Did not receive request for ");
       strcat(send_string,names[i]);
       WriteComString(send_string);
       return;
       }

    if ( search(input_port,"send_name") )
       /* continue   */ ;
    else
       {
       printf("Did not receive 'send_name' command for file: %s\n",names[i]);
       strcpy(send_string,"ERROR - Did not received 'send_name' command for file:");
       strcat(send_string,names[i]);
       WriteComString(send_string);
       return;
       }

    strcpy(send_string,names[i]);
    WriteComString(send_string);/* --- send the file name to Fluke - */
    usleep(20);

    /* printf("dir before strcpy(input_file,dir) :\n");  */
    /* printf("%s\n\n",dir);                             */

    strcpy(input_file,dir);
    strcat(input_file,"/");
    strcat(input_file,names[i]);

    /* printf("Sending '%s'\n",input_file);       */     /* */
    /* printf("to upload_file()\n\n",input_file); */     /* */

    temp = upload_file(input_file);    /*   *** transfer the file   ***    */

    /*     ***  send formfeed to indicate beginning of File  ***           */


   }   /* -----------   END FOR i < file_count+1   ----------------------- */

    return;
   }

/* *************  Transfer File FROM Sun TO Fluke   ********************* */
int upload_file(dir_name)

   char *dir_name;

   {
   FILE *in_file;
   FILE *fopen();
   char temp_string[300];
   char send_string[300];
   char c;
   int count, status;
   /* printf("Upload_file received filename: \n");  */   /* */
   /* printf("%s\n\n",dir_name);                    */   /* */
   status = TRUE;
   in_file = fopen(dir_name,"r");
   if ( in_file == NULL )
      {
       printf ("Upload_file couldn't open :\n");
       printf ("%s \n\n", dir_name );
       printf ("for Writing.\n");
       status = FALSE;
       strcpy(send_string,"ERROR - Could not open the file: ");
       strcat(send_string,dir_name);
       WriteComString(send_string);
       return(status);
       }

   temp_string[0] = '\f';
   temp_string[1] = '\0';
   WriteComString(temp_string);/*  *//* - Send formfeed to indicate the  */
                                     /* - beginning of the file   -----  */

   temp_string[0] = '\0';
   count = 0;
   c = '0';

   while ( c != EOF)              /* - Enter until End of Input File - */
        {
         c = fgetc(in_file);
         temp_string[count] = c;
         count++;

         if (c == '\n')
           {
            temp_string[count] = '\0';      /* and insert carriage return.*/
            WriteComString(temp_string);    /* Fluke will treat as a      */
            /* usleep(10);            */    /* Linefeed                   */
            count = 0;
           }
         }                      /* ------ END WHILE (c != EOF)   ------- */

   close(in_file);

   temp_string[0] = '\f';
   temp_string[1] = '\0';
   WriteComString(temp_string);/*  *//* - Send formfeed to indicate the  */
                                     /* - end of the file   -----------  */
   return(status);
   }
   ;

/***************************************************************************/
/*                    END OF FILE                                          */
/***************************************************************************/

